// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.8 Page 166
// Title: Semi-Infinite Cylinder Suddenly Exposed to Convection
//===================================================================
model Ex4_8
//=============
//Variable Section
Real T_r_o(unit ="C")"Temperature at the surface of he cylinder";
Real T_axis(unit ="C")"Temperature at the axis";


Real theta_by_theta_i;
Real ro(unit="cm")" Radius of the aluminium cylinder";
Real r(unit="cm")" Radius to compute the surface temperature ratio";
Real R"Surface temperature ratio";
Real A,B,C,D;
Real S_of_X;
Real w,v,s,t;
Real C_of_O_axis ;
Real C_of_O_r_o ;
//=============
//Parameter Section
parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real tow(unit="s")=60"Time after which the plate has been exposed to the environment";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the cylinder";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real d(unit="cm")=5" Diameter of the cylinder ";
parameter Real x(unit="cm")=10" Distance at which temperature is calculated from the end ";


//The below values are obtained from specified references

parameter Real theta_o_by_theta_i=0.38"Value obtained from Figure:4.8(Page:144-145) ";
parameter Real theta_by_theta_o = 0.98"Value obtained from Figure:4.11(Page:149) at x/L =0.5 ";

//=============
//Equation Section
equation
//Calculation of  radius of the cylinder
ro = d/2;
r = d/2;


A = h*((alpha*tow)^0.5)/k;
B = (x)/(2*(alpha*tow)^0.5);
theta_by_theta_i = 1-0.036;//Value obtained from Figure 4.5
S_of_X = theta_by_theta_i;


C = k/(h*ro);

D = (alpha*tow)/(ro^(2));

R = (r)/(ro);
 
w =  theta_o_by_theta_i; 			// at r = 0
v =  theta_o_by_theta_i*theta_by_theta_o ;		// at r = r_o

C_of_O_axis = w; 	// at r = 0
C_of_O_r_o = v ;	  // at r = r_o

//Combining the solutions for the semi-infinite slab and infinite cylinder
t = S_of_X*C_of_O_axis ;
s = S_of_X*C_of_O_r_o ;
// Calculation of corresponding temperatures 
T_axis = T_infinity+t*(Ti-T_infinity) ;
T_r_o = T_infinity+s*(Ti-T_infinity) ;

end Ex4_8;
//=================================================================
