// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.9 Page 166
// Title: Finite-Length Cylinder Suddenly Exposed to Convection
//===================================================================

//To solve this Problem we combine the solutions from the Heisler charts for an infinite cylinder and an infinite plate in accordance with the combination shown in Figure 4-18f

model Ex4_9

//=============
//Variable Section
Real T(unit ="C")"Temperature at a radial position of 0.0125 m and a distance of 0.00625m from one end of cylinder 60 second after exposure to environment";
Real x;
Real ro(unit="cm")" Radius of the aluminium cylinder";
Real R;
Real A,B,C,D;

Real theta_by_theta_i_shortcyl;
Real theta_by_theta_i_cyl ;
Real theta_by_theta_i_plate;
//=============
//Parameter Section

parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real tow(unit="s")=60"Time after which the plate has been exposed to the environment";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real xo(unit="cm")= 0.625" Distance at which temperature is calculated from end";
parameter Real d(unit="cm")=5" Diameter of the cylinder ";
parameter Real r(unit="cm")=1.25" Radial position at which temperature is to be computed ";
parameter Real L(unit="cm")=5" Length of the plate  ";

//The below values are obtained from specified references
parameter Real theta_o_by_theta_i=0.75"Value obtained from Figure:4.17(Page:144-145) ";
parameter Real theta_by_theta_o = 0.95"Value obtained from Figure:4.10(Page:149) at x/L =0.5 ";
parameter Real theta_o_by_i_cyl = 0.38 "Value obtained from Figure:4.8(Page:149)  ";
parameter Real theta_by_theta_o_cyl = 0.98 "Value obtained from Figure:4.11(Page:149)  ";
//=============
//Equation Section
equation
x = L-xo 	;		
A = k/(h*L) ;
B = (alpha*tow)/(L^2) ;

theta_by_theta_i_plate = theta_o_by_theta_i*theta_by_theta_o;

ro = d/2; 			
R = r/ro ;
C = k/(h*ro) ;
D = (alpha*tow)/(ro^2) ;

theta_by_theta_i_cyl = theta_o_by_i_cyl * theta_by_theta_o_cyl;

theta_by_theta_i_shortcyl  =  theta_by_theta_i_cyl* theta_by_theta_i_plate;

T = T_infinity+theta_by_theta_i_shortcyl*(Ti-T_infinity);

end Ex4_9;
