// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.3 Page 227
// Title: Mass Flow and Boundary-Layer Thickness
//===================================================================
model Ex5_3
//=============
// Variable Section
Real rho(unit="kg/m^3")"Density of air";
Real Red1"Reynolds number at x=20 cm";
Real Red2"Reynolds number at x=40 cm";
Real delta1(unit="m")"Boudary Layer thickness at x=20cm";
Real delta2(unit="m")"Boudary Layer thickness at x=40 cm";
Real deltam(unit="kg/s")"Mass Flow entering the boundary layer";

//=============
// Parameter Section
parameter Real T(unit="C")=27"Inlet temperature of air";
parameter Real P(unit="atm")=1"Inlet pressure of air";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real u_infinity(unit="m/s")=2"Velocity at which air flows in";
parameter Real mu(unit="kg/m.s")=1.85E-5"Viscocity of air at 27 C";
parameter Real x1(unit="cm")=20"Distance at which boundary layer thickness is calculated";
parameter Real x2(unit="cm")=40"Distance at which boundary layer thickness is calculated";

//=============
// Equation Section
equation
rho = (P*1.0132*1E5)/(R*(T+273));

//Calculation of Reynolds numbers at x=20cm and x=40cm
Red1 = (rho)*(u_infinity)*(x1*0.01)/(mu);
Red2 = (rho)*(u_infinity)*(x2*0.01)/(mu);

//Calculation of Boundary Layer thickness at x=20cm and x=40cm
delta1 = (4.64*x1*0.01)/((Red1)^0.5);
delta2 = (4.64*x2*0.01)/((Red2)^0.5);

//Calculation of mass flow that enters the boundary layer
deltam = (5/8) * rho *u_infinity*(delta2-delta1);

end Ex5_3;
//========================================================================
