// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.5 Page 238
//Title: Flat Plate with Constant Heat Flux
//===================================================================
model Ex5_5
//=============
// Variable Section
Real Re_L"Reynolds Number at Tf=27 C";
Real Re_L1"Reynolds Number at Tf=147 C";

Real Tw_Tinfinity_bar(unit="C");
Real Tw_Tinfinity_bar1(unit="C");
Real qw(unit ="W/m^2")"Heat Flux per unit area";
Real Tf(unit="C")"Film Temperature";

Real Tw_minus_Tinf_x_equal_l(unit="C")"Temperature difference at the end of the plate"  ;
//=============
// Parameter Section
parameter Real u_infinity(unit="m/s") =5"Velocity of air";
parameter Real L(unit ="cm") = 60"Plate Length";
parameter Real T_infinity(unit="C")=27"Temperature of air stream";

//Properties of air are taken from Appendix-A at the film temperature Tf=27 C
parameter Real v(unit="m^2/s")= 15.69*1E-6"Kinematic viscosity";
parameter Real Pr =0.708"Prandtl number";
parameter Real k(unit=" W/m.C") =0.02624 "Thermal Conductivity ";

//Properties of air are taken from Appendix-A at the film temperature Tf=147 C
parameter Real v1(unit="m^2/s")= 28.22*1E-6"Kinematic viscosity";
parameter Real Pr1 =0.687"Prandtl number";
parameter Real k1(unit=" W/m.C") =0.035 "Thermal Conductivity ";

parameter Real P(unit="kW")= 1"Power of heater";


//=============
// Equation Section
equation

//Calculation of temperature difference at Tf=27 C
Re_L =( u_infinity * L*0.01)/v ;
qw = (P*1000)/(L*0.01*L*0.01);

Tw_Tinfinity_bar = (qw*L*0.01)/(k*0.6795* (Re_L^0.5)* (Pr^0.333));

Tf =(Tw_Tinfinity_bar+T_infinity+T_infinity)/2;

//Calculation of temperature difference at Tf= 147 C
Re_L1 =( u_infinity * L*0.01)/v1 ;


Tw_Tinfinity_bar1 = (qw*L*0.01)/(k1*0.6795* (Re_L1^0.5)* (Pr1^0.333));

Tw_minus_Tinf_x_equal_l =( Tw_Tinfinity_bar1*0.6795)/0.453 ;

end Ex5_5;
//=======================================================
