// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.1 Page 287
// Title: Turbulent Heat Transfer in a Tube
//===================================================================
model Ex6_1
//=============
// Variable Section 
Real rho(unit="kg/m^3")"Density of air";
Real Red"Reynolds Number";
Real Nud"Nusselt Number";
Real h(unit="W/m^2.C")"Heat Transfer Coefficient";
Real q_by_L(unit="W/m")"Heat Flow per unit length";
Real m(unit="kg/s")"Mass Flow Rate";
Real delta_Tb(unit="C")"Bulk Temperature Increase";
//=============
// Parameter Section
parameter Real T(unit="C")=200"Bulk Temperature";
parameter Real Tw_Tb(unit="C")=20"Difference between wall and air temperature";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real p(unit="atm")=2"Presssure at which air flows";
parameter Real d(unit="inch")=1"Diameter of the tube";
parameter Real um(unit="m/s")=10"Velocity at which air flows";
//Properties at Bulk Temperature
parameter Real mu(unit="kg/m.s")=2.57E-5"Dynamic viscocity at bulk temperature";
parameter Real Pr=0.681"Prandtl Number";
parameter Real k(unit="W/m.C")=0.0386"Thermal conductiviy at bulk temperature";
parameter Real Cp(unit="kJ/kg.C")=1.025"Specific heat";

parameter Real L(unit="m")=3"Length of the tube";
//=============
// Equation  Section  
//Calculation of density of air
equation
rho = (p*101325)/(R*(T+273));

Red = (rho*um*(d*0.0254))/(mu);
Nud = 0.023 *(Red)^0.8 * (Pr)^0.4;

//Calculation of Heat Transfer Coefficient
h = Nud *(k/(d*0.0254));
q_by_L =  h * 3.14*(d*0.0254)*(Tw_Tb);

//Calculation of increase in bulk temperature for a 3m long tube
m =( rho *um* 3.14*(d*0.0254)^2)/(4);
m *Cp*1000*delta_Tb = L *(q_by_L);

end Ex6_1;
//========================================================================
