// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.12  Page 311
//Title: Heating of Liquid Bismuth in Tube
//==================================================================
model Ex6_12

//=============
// Variable Section

Real q(unit="kW")"Total heat transfer";
Real Red"Reynolds Number";
Real Pe"Peclet Number";
Real Nu"Nusselt Number";
Real A(unit="m^2")"Area of the tube";
Real L(unit="m")"Length of the tube";
Real h(unit="W/m^2.C")"Heat transfer coefficient";

//=============
// Parameter Section

parameter Real m(unit="kg/s")=4.5"Mass flow rate of liquid bismuth";
parameter Real d(unit="cm")=5"Diameter of stainless steel tube";
parameter Real Tb_in(unit="C")=415"Inlet temperature of liquid bismuth";
parameter Real Tb_out(unit="C")= 440"Outlet temperature of liquid bismuth";

parameter Real delta_T(unit="C")=20"Temperature difference between tube wall and bismuth bulk temperature";

//Properties eveluated at bulk temperature
parameter Real k(unit="W/m.C")=15.6"Thermal conductiviy at bulk temperature";
parameter Real mu(unit="kg/m.s")=1.34E-3"Dynamic viscocity at bulk temperature";
parameter Real cp(unit="kJ/kg.C")= 0.149"Specific heat at bulk temperature";
parameter Real Pr=0.013"Prandtl Number";

//=============
// Equation Section

equation
//Calculation of total heat transfer rate
q = m*cp*(Tb_out - Tb_in);

//Calculation of Reynolds Number
Red =  (d*0.01*m*4)/(mu*(3.14*d*d*0.01*0.01));

//Calculation of Peclet Number
Pe = Red * Pr;

//Calculation of Nusselt Number
Nu = 4.82 + (0.0185)*(Pe)^0.827;

//Calculation of heat transfer coefficient
Nu = (h*d*0.01)/k;

//Calculation of required surface area of the tube
A = (q*1000)/(h*(delta_T));

//Calculation of the length of the tube
L = A /(3.14*d*0.01);

end Ex6_12;
//===================================================================
