// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.3  Page 289
// Title: Heating of Air in Laminar Tube Flow for Constant Heat Flux
//===================================================================
model Ex6_3
//=============
// Variable Section
Real Tb_bar(unit="C")"Bulk Mean Temperature";
Real Red"Reynolds Number";
Real Gr_inverse"Inverse of Graetz number";
Real m(unit="kg/s")"Mass Flow Rate";
Real q(unit="W")"Heat transfer rate";
Real qw(unit="W/m^2")"Heat Flux";
Real Tw_Tb2(unit="C")"Temperature Difference";
Real Tw(unit="C")"Wall Temperature";
Real h(unit="W/m^2.C")"Heat Transfer coefficient at x=L";

//=============
// Parameter Section
parameter Real Tb2(unit="C")=77"Exit Bulk Temperature";
parameter Real Tb1(unit="C")=27"Air Temperature";
parameter Real Nud=4.7"Nusselt Number value obtained from Figure 6-5";

//Properties evaluated at Bulk Mean Temperature
parameter Real mu(unit="m^2/s")=18.22E-6"Kinematic viscocity at bulk temperature";
parameter Real Pr=0.703"Prandtl Number";
parameter Real k(unit="W/m.C")=0.02814"Thermal conductiviy at bulk temperature";
parameter Real Cp(unit="J/kg.C")=1006"Specific Heat";

parameter Real d(unit="mm")=5"Diameter of the tube";
parameter Real u(unit="m/s")=3"Flow velocity";
parameter Real x(unit="cm")=10"Length of the tube";
parameter Real rho(unit="kg/m^3")=1.1744"Density of air evaluated at the tube entrance";


//=============
// Equation Section
equation

//Calculation of Bulk Mean Temperature
Tb_bar =( Tb1+Tb2)/2;
//Calculation of Reynolds Number
Red = (u*d*1E-3)/(mu);
//Computation of inverse of Graetz Number 
Gr_inverse = (x*0.1)/(Red*Pr*d*0.001);

//Calculation of MassFlow rate
m = (rho*3.14*(d*0.001)^2*u)/(4);
//Calculation of heat transfer at exit bulk temperature =77 C
q = m*Cp*(Tb2-Tb1);
//Calculation of qw to evaluate the wall temperature
q = qw*3.14*(d*0.001)*x*0.01;

Nud = (qw*d*0.001)/((Tw_Tb2)*k);
//Calculation of wall temperature at exit
Tw = (Tw_Tb2)+Tb2;
//Calculation of heat transfer coefficient at the exit
h = qw/((Tw_Tb2));

end Ex6_3;
//==============================================================================
