// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.7  Page 300
// Title: Airflow Across Isothermal Cylinder
//===================================================================
model Ex6_7
//=============
// Variable Section
Real Re_f"Reynolds Number";
Real q_L(unit="W/m")"Heat Transfer per unit length";
Real T_f(unit="C")"Mean film temperature";
Real h(unit="W/m^2.C")"Heat Transfer Coeffiient"; 
Real rho_f(unit="kg/m^3")"Density at film temperature";

//=============
// Parameter Section
parameter Real Tw(unit="C")=150"Temperature at which cylinder surface is maintained";
parameter Real T_infinity(unit="C")=35"Temperature at which air enters";
parameter Real d(unit="cm")=5"Diameter of the tube";
parameter Real u_infinity(unit="m/s")=50"Flow velocity";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real P(unit="Pa")=101325"Presssure at which air flows";

//The below parameters are obtained from Table 6.2
parameter Real C=0.0266;
parameter Real n=0.805 ;

//Properties evaluated at Film Temperature 300K
parameter Real mu_f(unit="kg/m.s")=2.14E-5"Dynamic viscocity at film temperature";
parameter Real Pr_f=0.695"Prandtl Number";
parameter Real k_f(unit="W/m.C")=0.0312"Thermal conductiviy at film temperature";

//=============
//Equation Section
equation
//Mean Film Temperature
T_f = (Tw+T_infinity)/2;

//Calculation of density at film temperature
rho_f = (P)/(R*(T_f+273));

//Calculation of Reynolds Number
Re_f= (rho_f*u_infinity*d*0.01)/(mu_f);

//Calculation of heat transfer coefficient
((h*d*0.01)/(k_f) )= (C*((Re_f^n))*((Pr_f^(1/3))));

//Calculation of heat transfer rate per unit length
q_L = h*3.14*d*0.01*(Tw-T_infinity);

end Ex6_7;
//===================================================================
