// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.9  Page 302
// Title: Heat Transfer from Sphere
//===================================================================
model Ex6_9
//=============
// Variable Section
Real Re_d"Reynolds Number";
Real Nu_bar"Nusselt Number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient";
Real q(unit="W")"Heat transfer rate";

Real Tf(unit="C")"Film temperature";
Real Re_dd"Reynolds Number";
Real Nu_f"Nusselt Number calculated using Equation 6.25";
Real h_barr(unit="W/m^2.C")"Heat transfer coefficient";

//=============
// Parameter Section

parameter Real d(unit="mm")=12"Diameter of the sphere";
parameter Real T_infinity(unit="C")=27"Temperature at which air is flowing";
parameter Real u_infinity(unit="m/s")=4"Free stream velocity of air";
parameter Real T_w(unit="C")=77"Temperature of spherical surface";

//Properties evaluated at Free stream Temperature 300K
parameter Real v(unit="m^2/s")=15.69E-6"Kinematic viscocity at free stream temperature";
parameter Real Pr=0.708"Prandtl Number";
parameter Real k(unit="W/m.C")=0.02624"Thermal conductiviy at free stream temperature";

//Properties eveluated at film temperature
parameter Real v_f(unit="m^2/s")=18.23E-6"Kinematic viscocity at film temperature";
parameter Real k_f(unit="W/m.C")=0.02814"Thermal conductiviy at film temperature";

//Viscocoity correction factor terms
parameter Real mu_infinity(unit="kg/m.s")=1.8462E-5"Dynamic viscocity at air temperature";
parameter Real mu_w(unit="kg/m.s")=2.075E-5"Dynamic viscocity at surface temperature";
//=============
// Equation Section
equation

//Calculation of Reynolds Number
Re_d= (u_infinity*d*0.001)/(v);

//Calculation of Nusselt Number from Equation 6.30
Nu_bar = 2 +((0.4*(Re_d)^0.5 + 0.06*(Re_d)^(2/3)))*(Pr)^(0.4)*(mu_infinity/mu_w)^(0.25);

//Calculation of heat trasnfer coefficient
h_bar = Nu_bar *(k/(d*0.001));

//Calculation of heat transfer rate
q = h_bar * 4*3.14*(d*0.001/2)^2*(T_w - T_infinity);

//===================================================
//For comparision calculation of all the above terms using Equation 6.25
Tf = (T_w + T_infinity)/2;

//Calculation of Reynolds Number at film temperature
Re_dd= (u_infinity*d*0.001)/(v_f);

Nu_f =  0.37*(Re_dd)^0.6;

h_barr = Nu_f *(k_f/(d*0.001));

end Ex6_9;
//===================================================================
