// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.3 Page 340
// Title: Heat Transfer from Horizontal Tube inWater
//===================================================================
model Ex7_3
//=============
// Variable Section
Real Tf(unit="C")"Film temperature";
Real Nu"Nusselt Number";
Real h(unit="W/m^2.C")"Heat transfer coefficient";
Real q_L(unit="W/m")"Heat transfer rate per unit length of heater";
Real Ra"Rayleigh Number";
Real beta(unit="K^-1")"Coefficient of thermal expansion";

//=============
// Parameter Section
parameter Real Tw(unit="C")=38"Plate temperature";
parameter Real T_infinity(unit="C")=27"Surrounding atmosphere temperature";
parameter Real k(unit="W/m.C")=0.630"Thermal conductivity of water at film temperature";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";
parameter Real d(unit="cm")=2"Diameter of the heater";
parameter Real K=2.48E10"Value used to compute the Rayleigh number";

//Constants obtained from Table 7.1
parameter Real C= 0.53;
parameter Real m=0.25;

//=============
// Equation Section
equation
//Calculation of film temperature
Tf  = (Tw+ T_infinity)/2;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of Rayleigh Equation
Ra = K * (Tw-T_infinity)*(d*0.01)^3;

//Calculation of Nusselt Number
 Nu= C*((Ra)^(m));
 
//Calculation of heat transfer coefficient
 Nu= (h*d*0.01)/k;
 
 //Calculation of heat trasnfer rate
 q_L = h*3.14*d*0.01*(Tw-T_infinity);

end Ex7_3;
