// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.4 Page 341
// Title: Heat Transfer from Fine Wire in Air
//===================================================================
model Ex7_4
//=============
// Variable Section
Real Tf(unit="C")"Film temperature";
Real Nu"Nusselt Number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient";
Real q(unit="W")"Power required";
Real Ra"Rayleigh Number";
Real beta(unit="K^-1")"Coefficient of thermal expansion";

//=============
// Parameter Section
parameter Real Tw(unit="C")=54"Wire temperature";
parameter Real T_infinity(unit="C")=0"Surrounding atmosphere temperature";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";
parameter Real d(unit="mm")=0.02"Diameter of the heater";
parameter Real L(unit="cm")=50"Length of the wire";

//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=15.69E-6"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.02624"Thermal conductivity of air at film temperature";
parameter Real Pr=0.708"Prandtl Number";


//Constants obtained from Table 7.1
parameter Real C= 0.675;
parameter Real m=0.058;


//=============
// Equation Section
equation
//Calculation of film temperature
Tf  = (Tw+ T_infinity)/2;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of Rayleigh Equation
Ra = (g*beta * (Tw-T_infinity)*(d*1E-3)^3*Pr)/(v*v);

//Calculation of Nusselt Number
 Nu= C*((Ra)^(m));
 
//Calculation of heat transfer coefficient
 Nu= (h_bar*d*0.001)/k;
 
 //Calculation of Power required to maintain wire temperature
 q = h_bar*3.14*d*0.001*L*0.01*(Tw-T_infinity);


end Ex7_4;
//================================================================
