// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.14 Page 435
//Title: Transmitting and Reflecting System for Furnace Opening
//===================================================================
model Ex8_14
//=============
// Variable Section
Real Eb1(unit="W/m^2");
Real Eb3(unit="W/m^2");

//Fraction of radiation in wavelength bands
Real lamba_into_T1;
Real lamba_into_T3;

Real  Eb1_0_to_4;
Real  Eb3_0_to_4;
Real Eb1_4_to_inf;
Real Eb3_4_to_inf;

Real R1,R2,R3,R4,R5,R6,R7;

Real R_equiv_1,R_equiv_2;
Real q1(unit="W/m^2"),q2(unit="W/m^2");


Real q_total(unit="W/m^2");
Real Q(unit="W/m^2");

//=============
// Parameter Section
parameter Real T1(unit="C")=1000"Temperature of the furnace";
parameter Real lamda(unit="microm")=4;

parameter Real E1=0.1;
parameter Real t1 =0.9;
parameter Real rho1=0;

parameter Real sigma(unit="W/m^2.K^4") =5.67E-8"Stefan Boltman constant";

parameter Real E2=0.8;
parameter Real t2 =0;
parameter Real rho2=0.2;

parameter Real T3(unit="C")=30"Room temperature";

parameter Real A1(unit="m^2") = 1.0 ;			
parameter Real A2(unit="m^2") = 1.0; 		
parameter Real A3(unit="m^2") = 1.0 ;		
parameter Real F12 = 1.0 ;
parameter Real F13 = 1.0 ;
parameter Real F32 = 1.0 ;

//=============
// Equation Section
equation
Eb1 = sigma*(T1+273)^(4) ;		
Eb3 = sigma*(T3+273)^(4) ;

//Determination of fraction of radiation in wavelength regions
lamba_into_T1 = lamda*(T1+273); 	
lamba_into_T3 = lamda*(T3+273) ;

//Constants obtained from Table 8.1
Eb1_0_to_4 = 0.6450*Eb1; 	
Eb3_0_to_4 = 0.00235*Eb3; 	
Eb1_4_to_inf = (1-0.6450)*Eb1; 	
Eb3_4_to_inf = (1-0.00235)*Eb3; 

//Surface resistance
R1 = 1/(F13*t1) ;
R2 = 1/(F32*(1-t1)) ;
R3 = 1/(F12*(1-t1)) ;
R4 = rho1/(E1*(1-t1)) ;

R_equiv_1 = 1/(1/R1+1/(R2+R3+R4)) ;
q1 = (Eb1_0_to_4-Eb3_0_to_4)/R_equiv_1;

//Surface resistance from 4 micro meter to infinity band
R5 = 1/(F32*(1-t2)) ;
R6 = 1/(F12*(1-t2)) ;
R7 = rho2/(E2*(1-t2)) ;

R_equiv_2 = R5+R6+(R7*2) ;
q2 = (Eb1_4_to_inf-Eb3_4_to_inf)/R_equiv_2 ;

q_total = q1+q2 ;

Q = Eb1-Eb3 ;

end Ex8_14;
//========================================================================
