// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.2 Page 397
//Title: Heat Transfer Between Black Surfaces
//===================================================================
model Ex8_2
//=============
// Variable Section 
Real q(unit="kW")"Radiant heat transfer rate";

//Ratios for use in Fig: 8.12
Real Y_by_D;
Real X_by_D;

//=============
// Parameter Section 
parameter Real L(unit="m")=1"Length of the black plate";
parameter Real W(unit="m")=0.5"Width of the black plate";
parameter Real T1(unit="C")=1000"Temperature of first plate";
parameter Real T2(unit="C")=500"Temperature of second plate";
parameter Real F_12=0.285"Radiation Shape Factor";

parameter Real sigma(unit="W/m^2.K^4")=5.669E-8"Stefan Boltman constant";

//=============
// Equation Section 
equation
Y_by_D = W/W  ;
X_by_D = L/W  ;

//Calculation of radiant heat transfer rate 
q = F_12*L*W*sigma*((T1+273)^4-(T2+273)^4)*1E-3;

end Ex8_2;
//========================================================================
