// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.23 Page 460
//Title: Temperature Measurement Error Caused by Radiation
//===================================================================
model Ex8_23
//=============
// Variable Section
Real Tinf(unit="C");

//=============
// Parameter Section
parameter Real E = 0.9"Emissivity of mercury-in-glass thermometer"; 
parameter Real Tt(unit="C") = 20"Temperature indicated by thermometer"; 
parameter Real Ts(unit="C") = 5"Temperature of walls";
parameter Real sigma = 5.669E-8"Stefan-Boltman Constant";
parameter Real h(unit="W/m^2") = 8.3"Heat transfer coefficient for 	thermometer";

//=============
// Equation Section
equation

Tinf = sigma*E*((Tt+273)^4-(Ts+273)^4)/h+Tt ;

end Ex8_23;
//==================================================================
