// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.3 Page 401
//Title: Shape-Factor Algebra for Open Ends of Cylinders
//===================================================================
model Ex8_3
//=============
// Variable Section 
Real L_by_r2;
Real F_12;
Real F_23;
Real F_24;
Real F_32;
Real F_13;
Real F_14;
Real F_31;
Real F_34;
Real A1;
Real A2(unit="cm^2");
Real A3(unit="cm^2");

//=============
// Parameter Section 
parameter Real d1(unit="cm")=10"Diameter of cylinder 1";
parameter Real d2(unit="cm")=20"Diameter of cylinder 2";
parameter Real L(unit="cm")=20"Length of the cylinder";

//From figure 8-15(page no.-388) for this problem and designate the open ends as surfaces 3 and 4.
parameter Real r1_by_r2 = 0.5 ;

parameter Real F_21=0.4126;
parameter Real F_22=0.3286;
//=============
// Equation Section 
equation

L_by_r2 = L/(d2/2) ;

//Calculation of shape factors between open ends of the cylinder
F_12 = (d2/d1)*F_21;

F_23 = (1-F_21-F_22)/2;

F_24 = F_23;

A2 = 3.14*d2*1E-2*L*0.01;

A3 = (3.14*((d2*1E-2)^2-(d1*1E-2)^2))/4;

F_32 = A2*(F_23/A3);

F_13 = (1-F_12)/2;

F_14 = F_13;

A1 = 3.14*d1*1E-2*L*0.01;

F_31 = (A1/A3)*F_13;

F_34 = 1-F_31-F_32;

end Ex8_3;
//========================================================================
