// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.5 Page 403
//Title: Shape-Factor Algebra for Cylindrical Reflector
//===================================================================
model Ex8_5
//=============
// Variable Section 
Real A1;
Real A4;
Real A2;
//Shape factors
Real F_23;
Real F_14;
Real F_12;
Real F_13;
Real F_11;
//=============
// Parameter Section 
parameter Real d(unit="cm")=60"Diameter of long half cylinder";
parameter Real L(unit="cm")=20"Length of square rod";
parameter Real F_21=0.5;
parameter Real F_41 = 1;

//=============
// Equation Section 
equation
F_23 =F_21;

A1 = 3.14*((d*1E-2)/2);
A4 = (L*1E-2)+(2*sqrt(0.1^2+((L*1E-2)^2)));

A2=4*L*1E-2;

F_14=A4*(F_41/A1);

F_12=A2*(F_21/A1);

F_13=F_14-F_12;

F_11 = 1-F_12-F_13;

end Ex8_5;
//========================================================================
