// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.6 Page 511
//Title: Heat-Flux Comparisons
//===================================================================
//Note : The below example is solved using the data taken from Table:9.4
model Ex9_6
//=============
// Variable Section
Real q_A(unit="kW/cm^2")"Heat Flux in a solid copper bar";
//=============
// Parameter Section
parameter Real k(unit="W/m.C")=374"Thermal Conductivity of copper obtained from Table A:2";
parameter Real delta_x(unit="cm")=8"Length of the pipe";
parameter Real T_f(unit="C")=200"Temperature of the working fluid";
parameter Real T(unit="C")=100"Temperature Differential";
parameter Real q_A_axial(unit="kW/cm^2")=0.67"Axial heat Flux in a water pipe obtained from Table 9-4";

//=============
//  Equation Section
equation
//Calculation of heat flux
//Note:Multiplication by 0.001 and 0.0001 to convert the umits to kW/cm^2
q_A=   -k*((T-T_f)/(delta_x*0.01))*0.001*0.0001;

end Ex9_6;
//===================================================================
