// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.1 Page 16
// Title: Conduction through Copper Plate
//===================================================================
model Ex1_1


//=============
// Variable Section 
Real q_A(unit = "MW/m^2")"Heat Flux";


//=============
// Parameter Section 
parameter Real deltax(unit = "cm")=3"Thickness of the copper plate";
parameter Real T1(unit = "C")=400"Temperature of face 1";
parameter Real T2(unit = "C")=100"Temperature of face 2";

//Value obtained from Appendix-A
parameter Real k(unit ="W/m.C")=370"Thermal conductivity of copper at 250 C";


//=============
// Equation  Section 
equation

q_A = -k * ((T2-T1)/(deltax*0.01))*0.000001;//Fourier Law of Heat conduction
//Note : Multiplication of q by 0.000001 to convert to MW from W
//           Multiplication of deltax by 0.01 to covert to m from cm    
end Ex1_1;
//========================================================================
