// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.2 Page 17
// Title: Convection Calculation
//===================================================================
model Ex1_2

//=============
// Variable Section 
Real q(unit = "kW")"Heat transfer rate";
Real A(unit = "m^2")"Area of the plate";

//=============
// Parameter Section 

parameter Real T_infinity(unit ="C")= 20"Temperature of air";
parameter Real T_w(unit = "C")=250"Temperature of the hot plate";
parameter Real h(unit = "W/m^2.C")=25" Convection heat transfer coefficient";
parameter Real L(unit ="cm")=50"Length of the plate";
parameter Real B(unit = "cm")=75"Breadth of the plate";

//=============
// Equation Section 

equation
A = (L*0.01)*(B*0.01); //*Multiplication by 0.01 for conversion to m
q = h * A * (T_w-T_infinity)*0.001;//Calculation of heat transfer rate
//Multiplication by 0.001 for conversion to kW
 
end Ex1_2;
//========================================================================
