// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.4 Page 17
// Title: Heat Source and Convection
//===================================================================

model Ex1_4

//===============
// Libraries 
extends Modelica.Constants;

//=============
// Variable Section 

Real q(unit = "W")"Heat transfer rate";
Real A(unit= "m^2")"Surface Area of wire";

//=============
// Parameter Section 

parameter Real d(unit = "mm")=1"Diameter of the wire";
parameter Real L(unit = "cm")=10" Length of the wire";
parameter Real h(unit ="W/m^2.C")=5000"Heat-transfer coefficient";
parameter Real T_w(unit = "C")=114"Temperature of the wire surface";
parameter Real T_infinity(unit = "C")=100"Temperature of the water";

//=============
// Equation Section 

equation
A = pi*(d*0.001)*(L*0.01);
//Note: Multiplication of d by 0.001 to convert to m
//         Multiplication of L by 0.01 to convert to m
q = h * A *(T_w - T_infinity);//Calculation of Heat transfer rate

end Ex1_4;
//===================================================================
