// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.16 Page 558
//Title: Heat-Transfer Coefficient in Compact Exchanger
//===================================================================
model Ex10_16

//=============
// Variable Section

Real G(unit="kg/m^2.s")"Mass velocity";
Real Re"Reynolds Number";
Real h(unit="W/m^2.C")"Heat Transfer coefficient";

//=============
// Parameter Section

parameter Real rho(unit="kg/m^3")=1.1774"Density of air at specified temperature";
parameter Real mu(unit="kg/m.s")=1.983E-5"Viscocity at the specified temperature";
parameter Real cp(unit="kJ/kg")=1.0057"Specific heat of air";
parameter Real Pr=0.708;

parameter Real Dh(unit="mm")= 3.597;
parameter Real St_Pr_2_3 = 0.0036"Value obtained from Figure 10_19";

parameter Real Ac_A=0.697"Ratio of free flow area to frontal area";

parameter Real p(unit="atm")=1"Inlet pressure of air";

parameter Real T(unit="K")=300"Inlet temperature of air";
parameter Real u_infinity(unit="m/s")=15"Velocity at which air enters";
//=============
// Equation Section
equation 

//Calculation of mass velocity
G = (rho*u_infinity)/(Ac_A);

//Calculation of Reynolds number
Re = (Dh*1E-3*G)/(Ac_A);

//Calculation of heat transfer coefficent
h = (St_Pr_2_3) *G *cp*1000* (Pr)^(-2/3);

end Ex10_16;
//======================================================================== 
