// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.2 Page 525
// Title: Overall Heat-Transfer Coefficient for Pipe Exposed to Steam
//===================================================================
//The below problem is linked to Example 10_1
model Ex10_2

//=============
// Variable Section 
Real ho(unit="W/m^2.C")"Outside heat transfer coefficient";

Real To(unit="C")"Outside pipe surface temperature";
Real Ti(unit="C")"Inside pipe surface temperature";

Real Ro"Thermal resistance of outside surface";

Real Uo(unit="W/m^2.C")"Overall heat transfer coefficient";
//=============
//Parameter Section 
parameter Real hi(unit="W/m^2.C")=1961"Inside heat transfer coefficient";

parameter Real I_D(unit="m") = 0.0525"Value obtained from Appendix-A for 2 inch Schedule 40 pipe";
parameter Real O_D(unit="m") = 0.06033"Value obtained from Appendix-A for 2 inch Schedule 40 pipe";

parameter Real Tg(unit="C")=100"Temperature of steam";

//Water film properties
parameter Real rho(unit="kg/m^3")=960"Density at the desired temperature";
parameter Real k_f(unit="W/m.C")=0.68"Thermal conductivity at desired temperature";
parameter Real h_fg(unit="kJ/kg")=2255"Specific enthalpy";
parameter Real mu_f(unit="kg/m.s")=2.82E-4"Dynamic viscocity at the desired temperature";

parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

parameter Real Rs=4.097E-4"Thermal resistance of steel";
parameter Real Ri=3.092E-3"Thermal resistance of inside";
parameter Real Tw(unit="C")=98"Temperature at which water flows";
//=============
// Equation Section 
equation

//Calculation of outside heat transfer coefficient

ho = 0.725*((((k_f)^3*(g)*(h_fg*1000)*(rho)^2)/(mu_f*O_D*(Tg-To))))^0.25;

//Calculation of Ti and To

(Tg-To) = Ro*((To -Ti)/Rs);


(To -Ti)/(Rs) = ( Ti - Tw)/Ri;

//Thermal resistance for the outer surface


Ro = 1/(ho*3.14*O_D);

//Overall heat transfer coefficient

Uo = 1/(3.14*O_D*(Ri+Rs+Ro));

end Ex10_2;
//========================================================================
