// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.5 Page 537
// Title: Shell-and-Tube Heat Exchanger
//===================================================================
//Note: The below problem is linked to Example 10_4
model Ex10_5
//=============
// Variable Section 

//Parameters used to find out the correction factor
Real P;
Real R;

Real A(unit="m^2")"Heat transfer area";

//=============
// Parameter Section 
parameter Real t1(unit="C")=110"Inlet temperature of oil";
parameter Real t2(unit="C")=75"Outlet temperature of oil";

parameter Real T1(unit="C")=35"Inlet temperature of water";
parameter Real T2(unit="C")=75"Outlet temperature of water";

parameter Real F=0.81"Shell and tube correction factor";

parameter Real delta_Tm(unit="C")=37.44"Log mean temperature difference";
parameter Real q(unit="kW")=1.895E5"Heat transfer rate";
parameter Real U(unit="W/m^2.C")=320"Overall heat transfer coefficient";
//=============
// Equation Section 
equation

//Calculation of parameters used to find the correction factor
P = (t2 -t1)/(T1 -t1);

R = (T1 -T2)/(t2 -t1);

//From Figure 10_8 the correction factor is  F =0.81 which is given as a parameter in the code

A =  q /(U*delta_Tm*F);

end Ex10_5;
//======================================================================== 
