// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.6 Page 537
// Title: Design of Shell-and-Tube Heat Exchanger
//===================================================================
model Ex10_6
//=============
// Variable Section 
Real Th_exit(unit="C")"Exit tempearature of hot fluid";

Real q(unit="kW")"Heat transfer rate";

Real delta_Tm(unit="C")"Log mean temperature difference";

Real A(unit="m^2")"Heat transfer area";
Real A_flow(unit="m^2")"Flow area";

Real A_total(unit="m^2")"Area for two tube passes";

Real n"Number of tubes";
Real L(unit="m")"Length of the tube";
Real L_corr(unit="m")"Corrected Length for two tube passes";

//=============
// Parameter Section 
parameter Real mc(unit="kg/s")=3.783"Mass flow rate of water";

parameter Real Tc_in(unit="C")=37.78"Inlet temperature of cold water";
parameter Real Tc_out(unit="C")=54.44"Outlet temperature cold water";

parameter Real mh(unit="kg/s")=1.892"Mass flow rate of water";

parameter Real Cp_h(unit="J/kg.C")=4182"Specific heat of hot fluid";
parameter Real Cp_c(unit="J/kg.C")=4182"Specific heat of  cold fluid ";

parameter Real Th_in(unit="C")=93.33"Inlet temperature of hot fluid";

parameter Real U(unit="W/m^2.C")=1419"Overall heat transfer coefficient";

parameter Real u(unit="m/s")=0.366"Velocity of water in tubes";

parameter Real d(unit="cm")= 1.905"Diameter of the tube";
parameter Real rho(unit="kg/m^3")=1000"Density of water";

parameter Real F =0.88"LMTD correction factor";
//=============
// Equation Section 
equation
//For the first iteration one tube pass is assumed
mh*Cp_h*(Th_in-Th_exit )=  (mc*Cp_c*(Tc_out - Tc_in));

//Calculation of heat transfer rate
q = (mc* Cp_c*(Tc_out- Tc_in))*1E-3;

//Calculation of Log mean temperature difference
delta_Tm = ((Th_in - Tc_out)-(Th_exit - Tc_in))/log((Th_in - Tc_out)/(Th_exit - Tc_in));

//Calculation of heat transfer area
A = (q*1000)/(U*delta_Tm);

//Calculation of flow area
A_flow = mc/(rho*u);

//Calculation of number of tubes
n = (A_flow*4)/(3.14*(d*1E-2)^2);

//Length of the tube
L = A/(n*3.14*d*1E-2);

//The length calculated above is more than the allowable length specified in the problem. LMTD correction factor obtained from
//Figure 10.8 F =0.88

//Calculation of corrected area for two tube passes
A_total = (q*1000)/(U*F*delta_Tm);

//Corrected length
L_corr =( A_total)/(2*n*3.14*d*1E-2);

end Ex10_6;
//======================================================================== 
