// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-11: Mass Transfer
//Example: 11.2 Page 593
// Title: Diffusion of Water in a Tube
//===================================================================
model Ex11_2

//=============
// Variable Section 
Real pa1(unit="Pa")"Partial pressure at the bottom of the test tube";
Real pa2(unit="Pa")"Partial pressure at the top of the test tube";
Real mw(unit="kg/s")"Diffusion rate of water";
Real A(unit= "m^2")"Area of the tube";


//=============
//Parameter Section
parameter Real p(unit="psi") = 14.696"Total Pressure";
parameter Real D(unit="cm^2/s")=0.256"Diffusion Coefficient obtained from Table A-8";
parameter Real Mw=18"Molecular Weight of water";
parameter Real Ro(unit="(cm^3 kPa/Kmol)")=8314"Gas Constant";
parameter Real T(unit="K")=298"Temperature of the system";
parameter Real x2(unit="cm")=15"End Length of the tube";
parameter Real x1(unit="cm")=0"Starting Length of the tube";
parameter Real d(unit="mm")=10"Diameter of the tube";
parameter Real pw1(unit="psi")=0.4593"Vapour pressure at the bottom of the tube";
parameter Real pw2(unit="psi")=0"Vapour pressure at the top of the tube";

//=============
//Equation Section
equation
//Calculation of area of the tube
//Note:Multiplication by 0.001 to convert from mm to m
A = 3.14 *((d/2)*0.001)^2;
//Calculation of Partial Pressures at the top and bottom
//Note: Multiplication by 6894.7 t convert p from psi to Pa
pa1 = (p*6894.76)-(pw1*6894.76);
pa2 = (p*6894.76)-(pw2*7894.76);
//Calculation of Diffusion rate of water
//Note:  Multiplication of D by 1E-4 to convert to m^2
//           Multiplication of x2 by 0.01 to convert to m 
mw = ((D*1E-4)*(p*6894.76)*(Mw)*A)/(Ro*T*(x2-x1)*0.01) * log(pa2/pa1);


end Ex11_2;
//========================================================================
