// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady-state Conduction-One Dimesnsion
//Example: 2.2 Page 32
// Title: Multilayer Cylindrical System
//===================================================================
model Ex2_2

extends Modelica.Constants;
//=============
// Variable Section 

Real q_L(unit="W/m")"Rate of heat flow per unit length";
Real r1(unit = "m")"Inner radius of steel";
Real r2(unit = "m")"Outer radius of steel";
Real r3(unit = "m")" Combined radius of pipe and insulation";
//Series of thermal Resistance 
Real R1;
Real R2;
Real Ta(unit="C")"Tube Interface Temperature";

//=============
// Parameter Section

parameter Real d1(unit = "cm")=2"Inner diameter of steel";
parameter Real d2(unit = "cm")=4"Outer diameter of steel";
parameter Real t(unit = "cm")=3"Thickness of Asbestos Insulation"; 
parameter Real T1(unit="C")=600"Inside Wall Temperature";
parameter Real T2(unit="C")=100"Outside Wall Temperature";
parameter Real ka(unit="W/m.C")=0.2"Thermal Conductivity of Asbestos";
parameter Real ks(unit="W/m.C")=19"Thermal Conductivity of stainless steel";

//=============
// Equation Section
equation

//Calcuation of induvidual section radii
r1 =  (0.5*d1*0.01);
r2 =  (0.5*d2*0.01);
r3 = r2 + (t*0.01);

//Calculation of thermal resistances
R1 = (log(r3/r2)/((ka)));
R2 = (log(r2/r1)/((ks)));

//Calculation of rate of heat flow per unit length
q_L = ((2*pi)*(T1-T2)/(R1 +R2));
q_L = ((2*pi)*(Ta-T2)/(R1));

end Ex2_2;
//========================================================================
