// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady State Conduction : One Dimension
//Example: 2.7 Page 44
//Title: Heat Source with Convection
//===================================================================
model Ex2_7

//=============
// Variable Section 
Real R(unit = "ohm")"Resistance of the wire";
Real P(unit = "W")"Power generated in the wire";
Real q(unit = "MW/m^3")"Heat generated per unit volume";
Real To(unit = "C")"Centre temperature of the wire";
Real A(unit = "cm^2")"Cross sectional area of the wire";
Real r(unit = "mm")"Radius of the wire";
Real Tw(unit = "C")" Wire temperature";


//=============
// Parameter Section 
parameter Real I(unit="A")=200"Current in the wire";
parameter Real k(unit="W/m.K")=19"Thermal conductivity of the wire";
parameter Real d(unit="mm")=3"Diameter of the wire";
parameter Real rho(unit="mu-ohm")=70"Resistivity of the wire";
parameter Real L(unit="m")=1"Length of the wire";
parameter Real T_infinity(unit="C")=110"Temperature of the liquid";
parameter Real h(unit="W/m^2.C") = 4"Heat transfer coefficient";

//=============
// Equation Section 
equation
r = 0.5*d;// Calculation of radius in mm

A = 3.14 *r*0.1*r*0.1;//Area of the wire in cm^2
//Note: Multiplication of r by 0.1 to convert to cm from mm

R = ((rho * 0.000001)*(L*100))/A;//Resistivity of the wire in ohm
//Note : Multiplication of rho by 0.000001 to convert to ohm from mu_ohm
//          Multiplication of L by 100 to convert to cm from m

P = I * I * R;//Calculation of power generated in the wire

P = h*1000*3.14*d*0.001*L*(Tw-110);//Calculation of the wire temperature
P = q * (3.14*r*r*L);// Calculation of heat generated per unit volume

To = (q*r*r)/(4*k) + Tw;//Centre temperature of the wire

end Ex2_7;
//===================================================================
