// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-3: Steady-State Conduction: Multiple Dimension 
//Example: 3.4 Page 88
// Title: Buried Parallal Disks
//===================================================================
model Ex3_4

//Libraries
extends Modelica.Constants;

//=============
// Variable Section 
Real q(unit="W");
Real S"Shape Factor";

Real r(unit="m")"Radius of the disk";

//=============
// Parameter Section 
parameter Real d(unit="cm")=50"Diameter of the disks";
parameter Real D(unit="m")=1.5"Distance between the two disks";
parameter Real k(unit="W/m.K")=2.3"Thermal conductivity of the surface";

parameter Real T_disc_I(unit="C")=80"Temperature of the disk I";
parameter Real T_disc_II(unit="C")=20"Temperature of the disk II";
//=============
// Equation Section 
equation
r = (d*0.01)/2;

//Calculation of Shape Factor
S = (4*pi*r)/((pi/2) -  atan(r/D));

//Calculation of heat transfer rate
q = k*S*(T_disc_I - T_disc_II);

end Ex3_4;
//======================================================
