// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.1 Page 143
// Title:  Steel Ball Cooling in Air
//===================================================================
model Ex4_1
//=============
// Variable Section
Real tow(unit = "s")"Time required by the ball to attain 150 C";
Real A(unit = "m^2")" Surface area of the spherical ball";
Real V(unit = "m^3")" Volume of the spherical ball";
Real m;


//=============
// Parameter Section
parameter Real k (unit= "W/m.C")= 35"Thermal conductivity of the material";
parameter Real d (unit= "cm")= 5" Diameter of the spherical ball";
parameter Real h (unit= "W/m^2.C")= 10"Convection heat transfer coefficient";
parameter Real rho (unit= "kg/m^3")= 7800" Density of the material";
parameter Real c (unit= "kJ/kg.C")= 0.46"Specific heat";
parameter Real T_infinity (unit= "C")= 100"Temperature of the environment";
parameter Real T (unit= "C")= 150"Temperature to be attained by the ball";
parameter Real To (unit= "C")= 450"Initial temperature of the ball";

//=============
// Equation Section

equation
//Computation of area and volume of the spherical ball
A = 4 *3.14 *((d/2)*0.01)^2;
V = 4/3 *3.14 * ((d/2)*0.01)^3;

//Lumped-Capacity method
m = (h*A)/(rho*c*1000*V);
log((T-T_infinity)/(To-T_infinity)) = (-m*tow);
//Note: Mulatiplication of c by 1000 to convert to J from kJ

end Ex4_1;

//===================================================================
