// Holman  J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.10 Page 166
// Title: Heat Loss for Finite-Length Cylinder
//===================================================================
//The below problem is linked to Example 4.9

model Ex4_10
//=============
//Variable Section

Real ro(unit="cm")" Radius of the aluminium cylinder";
Real R;
Real A,B,C,D,V;
Real Q(unit="kJ")"Actual heat loss";
Real Qo;

Real Q_by_Qo_tot"Heat ratio" ;
//=============
//Parameter Section

parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real tow(unit="s")=60"Time after which the plate has been exposed to the environment";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real xo(unit="cm")= 0.625" Distance at which temperature is calculated from end";
parameter Real d(unit="cm")=5" Diameter of the cylinder ";
parameter Real r(unit="cm")=1.25" Radial position at which temperature is to be computed ";
parameter Real L(unit="cm")=5" Length of the plate  ";
parameter Real l(unit="cm")=1" Length of the cylinder ";

parameter Real c(unit="J/kg.C")=896"Specific Heat of Aluminium";
parameter Real rho(unit="kg/m^3")=2707"Density of Aluminium";

//The below values are obtained from specified references
parameter Real theta_o_by_theta_i=0.75"Value obtained from Figure:4.17(Page:144-145) ";
parameter Real theta_by_theta_o = 0.95"Value obtained from Figure:4.10(Page:149) at x/L =0.5 ";
parameter Real theta_o_by_i_cyl = 0.38 "Value obtained from Figure:4.8(Page:149)  ";
parameter Real theta_by_theta_o_cyl = 0.98 "Value obtained from Figure:4.11(Page:149)  ";
parameter Real Q_by_Qo_plate= 0.22"Value obtained from Figure:4.14(Page:152) ";
parameter Real Q_by_Qo_cyl = 0.55"Value obtained from Figure:4.15(Page:152) ";

//=============
//Equation Section

equation

ro = d/2;	
A = k/(h*L) ;
B = (h*h*alpha*tow)/(k*tow) ;
			
R = r/ro ;
C = (h*ro)/k ;
D = (alpha*tow)/(ro^2) ;
Q_by_Qo_tot = Q_by_Qo_plate+Q_by_Qo_cyl*(1-Q_by_Qo_plate);

V = 3.14*((ro*0.01)^2)*l*0.1;

//Note : Multiplication by 0.1 to convert l to m
Qo = rho*c*1E-3*V*(Ti-T_infinity);
Q = Qo*Q_by_Qo_tot ;

end Ex4_10;
//=====================================================================
