// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.3 Page 146
// Title:Pulsed Energy at Surface of Semi-Infinite Solid
//===================================================================
model Ex4_3
//=============
// Variable Section
//Temperatures at the surface and at a depth of 2 mm
Real T(unit="C");
Real T0(unit="C");

//=============
// Parameter Section
parameter Real Q0_A(unit="MJ/m^2") = 1E7"Instanteneous pulse layer";

//Properties of Stainless Steel
parameter Real rho(unit="kg/m^3") = 7800;
parameter Real c(unit="J/kg.C")=460;
parameter Real alpha(unit="m^2/s")=0.44E-5;

parameter Real Ti(unit="C")=40"Slab temperature";
parameter Real x(unit="mm")=2"Depth at which temperature is estimated";
parameter Real tow(unit="s")=2"Time after which temperature is calculated" ;

//=============
// Equation Section
equation
T0 - Ti =( (Q0_A)/(rho*c*((3.14*alpha*tow)^0.5)));  //typing mistake in book
//At x = 2mm
(T -Ti)/(T0-Ti)= exp(-(0.002^2)/((4)*(alpha)*(tow)));

end Ex4_3;
//=========================================================================
