// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.4 Page 147
// Title:  Heat Removal from Semi-Infinite Solid
//===================================================================
model Ex4_4
//=============
// Variable Section
Real Q_A(unit= "J/m^2")"Heat removed from the slab per unit surface area";
Real tow(unit="s")"Time intreval";
Real erf"Error Function";

//=============
// Paramteter Section
parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real To(unit = "C")= 70"Final Temperature of the slab";
parameter Real erf_value =0.3553"Value of Error Function obtained from Figure-4.4 in Page 145";

//Temperature at a depth of 4cm 
parameter Real T(unit = "C")= 120"Temperature at a depth of 4cm from the slab";

//=============
// Equation Section
equation
//Calculation of Error Function
erf = (T-To)/(Ti-To);

//Calculation of total heat removed at the surface
tow = ((4*0.01)^2)/((4)*(erf_value)^2*(alpha));
Q_A = 2*k*(To-Ti)*(((tow)/(3.14*alpha)))^0.5;

end Ex4_4;
//===========================================================
