package Ex5_10
// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.10 Page 251
// Title: Turbulent-Boundary-Layer Thickness
//===================================================================
//Note: The below Example is linked to Example_5.9
model Ex5_10_a
//=============
// Variable Section
Real delta(unit="m")"Boundary layer thickness from the leading edge of the plate";
//=============
// Parameter Section
parameter Real Re_L=1.553E6"Reynolds Number";
parameter Real L(unit="m")=0.75"Length of the plate";

//=============
// Equation Section
equation
//Calculation of boundary layer thickeness from the leading edge of plate
delta = L*0.381*(Re_L)^(-0.2);

end Ex5_10_a;
//========================================================================
// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.10.b Page 251
// Title: Turbulent-Boundary-Layer Thickness
//===================================================================
//Note: The below Example is linked to Example_5.9
model Ex5_10_b
//=============
// Variable Section
Real delta(unit="m")"Boundary layer thickness from the transition point";
//=============
// Parameter Section
parameter Real Re_L=1.553E6"Reynolds Number";
parameter Real L(unit="m")=0.75"Length of the plate";

//=============
// Equation Section
equation
//Calculation of boundary layer thickeness from the transition point
delta =( L*0.381*(Re_L)^(-0.2))-(10256*(Re_L)^(-1));

end Ex5_10_b;
//========================================================================

end Ex5_10;
