package Ex5_4


//The below problem is linked to Example 3
//Assumptions: The plate in Example 3 is heated to a temperature of 60 C

// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.4  Page 237
// Title: Isothermal Flat Plate Heated Over Entire Length
//===================================================================



model Ex5_4_a

//=============
// Variable Section

Real Tf(unit="C")"Film Temperature";
Real Re_x"Reynolds Number";
Real Nu_x"Nusselt Number";
Real h_x(unit="W/m^2.C")"Heat Transfer Coefficient";
Real h_bar(unit="W/m^2.C")"Average Heat Transfer Coefficient";
Real A1(unit = "m^2")"Area for unit depth";
Real q(unit="W")"Heat Flow";


//=============
// Parameter Section
parameter Real T_infinity(unit="C")=27"Temperature of air";
parameter Real Tw(unit="C")=60"Temperature of the plate";
parameter Real u_infinity(unit="m/s")=2"Velocity at which air flows in";

//Properties of air are taken from Appendix-A at the film temperature Tf
parameter Real v(unit="m^2/s")= 17.36*1E-6"Kinematic viscosity";
parameter Real x1(unit="cm") = 20 "Distance from the leading edge of plate";
parameter Real k(unit="W/m.K")= 0.02749 "Thermal Conductivity";
parameter Real Pr =0.7"Prandtl number";
parameter Real Cp(unit=" J/kg K") =1006 "Specific Heat of air";


//=============
// Equation Section
equation

//Calculation of heat transfer coefficient
//Note:Multiplication by 0.01 to convert from cm to m
Tf = (Tw + T_infinity)/2;
Re_x = (u_infinity)*(x1*0.01)/(v);
Nu_x = 0.332*(Re_x^(0.5))*(Pr^(0.333)) ;
Nu_x = (h_x)*(x1*0.01)/(k);

//Calculation of average heat transfer coefficient
h_bar = 2*h_x;
A1 = x1*1 ;

//Calculation of heat flow
//Note: Multiplication by 1E-3 to convert from W to kW
q = h_bar*x1*0.01*(Tw-T_infinity);

end Ex5_4_a;
//==============================================================


// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.4 Page 237
// Title: Isothermal Flat Plate Heated Over Entire Length
//===================================================================
//The below problem is linked to Example 3
//Assumptions: The plate in Example 3 is heated to a temperature of 60 C

model Ex5_4_b

//=============
// Variable Section
Real Tf(unit="C")"Film Temperature";
Real Re_x"Reynolds Number";
Real Nu_x"Nusselt Number";
Real h_x(unit="W/m^2.C")"Heat Transfer Coefficient";
Real h_bar(unit="W/m^2.C")"Average Heat Transfer Coefficient";
Real A1(unit = "m^2")"Area for unit depth";
Real q(unit="W")"Heat Flow";


//=============
// Parameter Section
parameter Real T_infinity(unit="C")=27"Temperature of air";
parameter Real Tw(unit="C")=60"Temperature of the plate";
parameter Real u_infinity(unit="m/s")=2"Velocity at which air flows in";

//Properties of air are taken from Appendix-A at the film temperature Tf
parameter Real v(unit="m^2/s")= 17.36*1E-6"Kinematic viscosity";
parameter Real x1(unit="cm") = 40 "Distance from the leading edge of plate";
parameter Real k(unit="W/m.K")= 0.02749 "Heat transfer coefficient";
parameter Real Pr =0.7"Prandtl number";
parameter Real Cp(unit=" J/kg K") =1006 "Specific Heat of air";


//=============
// Equation Section
equation

//Calculation of heat transfer coefficient
//Note:Multiplication by 0.01 to convert from cm to m
Tf = (Tw + T_infinity)/2;
Re_x = (u_infinity)*(x1*0.01)/(v);
Nu_x = 0.332*(Re_x^(0.5))*(Pr^(0.333)) ;
Nu_x = (h_x)*(x1*0.01)/(k);

//Calculation of average heat transfer coefficient
h_bar = 2*h_x;
A1 = x1*1 ;

//Calculation of heat flow
//Note: Multiplication by 0.01 to convert from cm  to m
q = h_bar*x1*0.01*(Tw-T_infinity);

end Ex5_4_b;
//================================================================
end Ex5_4;
