// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.6 Page 239
// Title: Plate with Unheated Starting Length
//===================================================================
model Ex5_6

//=============
// Variable Section
Real Tf(unit="C")"Film temperature";

Real Re_L"Reynolds Number";
Real h_x(unit="W/m^2.C")"Heat transfer coefficient";

Real q(unit="W")"Heat transfer rate";

//=============
// Parameter Section
parameter Real T_infinity(unit="K")=300"Inlet temperature of air";
parameter Real T_w(unit="K")= 350"Plate temperature";
parameter Real P(unit="atm")=1"Inlet pressure of air";

parameter Real L(unit="cm")=20"Length of the plate";
parameter Real u_infinity(unit="m/s")=20"Velocity at which air flows in";

parameter Real x_o(unit="m")=0.1"Position of the plate";
parameter Real x(unit="m")=0.2" FinalPosition of the plate";

parameter Real v (unit="m^2/s")= 18.23E-6 "Kinematic viscosity";
parameter Real k(unit="W/m.C") = 0.02814" Thermal Conductivity of material";
parameter Real Pr = 0.7" Prandtl number";

//=============
// Equation Section
equation
//Calculation of film temperature
Tf = (T_w+T_infinity)/2;

//Calculation of Reynolds number
Re_L = (u_infinity*L*0.01)/v;

//Calculation of heat transfer coefficient
//Simplified Equation on Integration
q = L*0.01*8.6883*0.4845*(T_w - T_infinity);

//Calculation of heat transfer coefficient
h_x = q/((T_w - T_infinity)*((L*0.01) - x_o)*L*0.01);

end Ex5_6;
//========================================================================
