// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.7 Page 240
// Title: Oil Flow Over Heated Flat Plate
//===================================================================
model Ex5_7
//=============
// Variable Section
Real q(unit="W")"Heat Lost by the plate";
Real hx(unit="W/m^2.C")"Heat Transfer Coefficient";
Real Tf(unit="C")"Film Temperature";
Real h(unit="W/m^2.C")"Average Heat Transfer Coefficient";
Real Re"Reynolds Number";
Real Nux"Nusselt Number";
Real A(unit="m^2")"Area of the plate";

//=============
// Parameter  Section
parameter Real u_infinity(unit="m/s")=1.2"Velocity of oil";
parameter Real L(unit="cm")= 20"Plate length ";
parameter Real To(unit="C")= 20"Temperature of engine oil";
parameter Real Tu(unit="C")= 60"Uniform temperature of the plate";
parameter Real rho(unit="kg/m^3") = 876 "Density of oil";
parameter Real v (unit="m^2/s")= 0.00024 "Kinematic viscosity";
parameter Real k(unit="W/m.C") = 0.144" Thermal Conductivity of material";
parameter Real Pr = 2870" Prandtl number";

//=============
// Equation Section
equation
//Calculation of Film Temperature
Tf = (To+Tu)/2; 	

//Calculation of heat transfer coefficient
Re=( u_infinity*L*0.01)/(v );
Nux = (0.3387*(Re^(1.0/2.0))*(Pr^(1.0/3.0)))/((1+(0.0468/Pr)^(2.0/3.0))^(1.0/4.0));

hx = (Nux*k)/(L*0.01);
h = 2*hx 	;

//Calculation of Heat lost by the plate
A = (L*0.01)^(2) 	;	
q = h*A*(Tu-To);

end Ex5_7;
//==========================================================================
