// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-5: Principles of Convection
//Example: 5.8 Page 242
// Title: Drag Force on a Flat Plate
//===================================================================
//The below problem is linked to Example 5.4
model Ex5_8
//=============
// Variable Section
Real rho"Density at the film temperature";
Real St_bar"Stanton Number";
Real Cf_bar ;
Real tou_w_bar(unit="N/m^2")"Average Shear Stress at the wall";
Real A(unit="m^2")"Area per unit length";
Real D(unit="mN")"Drag Force";


//=============
// Parameter Section
parameter Real p(unit="Pa") = 101325" Pressure of air";
parameter Real x(unit="m") = 0.4" Drag force is computed on first 0.4 m of the  plate ";
parameter Real R(unit="J/kg.K") = 287 "Gas Constat";
parameter Real Tf(unit="C")= 316.5"Film Temperature";
parameter Real u(unit="m/s") = 2"Air velocity";
parameter Real Cp(unit="J/kg.K") =1006 "Specific Heat";
parameter Real Pr = 0.7"Prandtl Number";
parameter Real h_bar(unit="W/m^2.K") = 8.698" Heat transfer coefficient";

//=============
// Equation Section
equation
rho = p/(R*Tf);

St_bar = h_bar/(rho*Cp*u); 
Cf_bar = St_bar*(Pr^(2/3))*2 ;

tou_w_bar = (Cf_bar*rho*u^2)/2;

//Calculation of area per unit length
A = x*1 ;
//Calculation of Drag Force
//Note:Multiplication by 1000 to convert D from N to mN
D = tou_w_bar*A*1000;

end Ex5_8;
//====================================================================
