// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.9  Page 306
// Title: Heating of Air with In-Line Tube Bank
//===================================================================
model Ex6_10
//=============
// Variable Section
Real Tf_1(unit="C")"Film temperature";
Real rho_f(unit="kg/m^3")"Density evaluated at film temperature";
Real rho_infinity(unit="kg/m^3")"Density at free stream temperature";
Real u_max(unit="m/s")"Maximum velocity";
Real Re"Reynolds Number";
Real A(unit="m^2")"Surface area of tubes";


Real T_infinity_2(unit="C")"Temperature at the exit of the tubes";
Real q(unit="kW/m")"Heat transfer rate";
Real m(unit="kg/s")"Mass flow rate at the entrance of the tubes";
Real h(unit="W/m^2.C")"Heat transfer coefficient"; 

//=============
// Parameter Section
parameter Real d(unit="cm")=2.54"Diameter of the tubes";
parameter Real T_infinity(unit="C")=10"Temperature at which air is flowing";
parameter Real N=15"Height of the number of rows";
parameter Real D=5"Depth of the rows";
parameter Real u_infinity(unit="m/s")=7"Free stream velocity of air";
parameter Real T_w(unit="C")=65"Temperature of tube surface";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real P(unit="Pa")=101325"Presssure at which air flows";

//Properties eveluated at film temperature
parameter Real k_f(unit="W/m.C")=0.027"Thermal conductiviy at film temperature";
parameter Real mu_f(unit="kg/m.s")=1.894E-5"Dynamic viscocity at surface temperature";
parameter Real cp_f(unit="J/kg.C")= 1007"Specific heat at film temperature";
parameter Real Pr=0.706"Prandtl Number";

//Constants obtained from Table6-4
parameter Real Sn =3.81;
parameter Real Sp_d =1.5;
parameter Real Sn_d =1.5;
parameter Real C=0.278;
parameter Real n=0.620;

//=============
// Equation Section
equation

//Calculation of film temperature
Tf_1 = (T_w + T_infinity)/2;

//Calculation of density at film temperature
rho_f = (P)/(R*(Tf_1+273));

//Calculation of maximum velocity
u_max = u_infinity *(Sn/(Sn - d));

//Calculation of Reynolds Number
Re = (rho_f*u_max*d*0.01)/(mu_f);

//Calculation of heat transfer coefficient
(h*d*0.01)/k_f = C*(Re)^n *(Pr)^(1/3);

//Surface area of tubes
A = N*5*3.14*d*0.01;

//Calculation of density at free stream temperature
rho_infinity = (P)/(R*(T_infinity+273));

//Calculation of mass flow rate at the entrance to 15 tubes
m = rho_infinity *u_infinity*(N)*Sn*0.01;

//Calculation of air temperature at the exit of tubes
0.92*h*A*(T_w - ((T_infinity + T_infinity_2)/2)) = m*cp_f*(T_infinity_2 - T_infinity);

//Calculation of heat transfer rate
q = m*cp_f*(T_infinity_2 - T_infinity)*1E-3;

end Ex6_10;
//===================================================================
