// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.11  Page 308
// Title: Alternate Calculation Method
//===================================================================
//Note: The below Example is linked to Example 6.10
model Ex6_11

//=============
// Variable Section
Real Red"Reynolds Number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient"; 
Real h_bar_correct(unit="W/m^2.C")"Corrected Heat transfer coefficient for 5 tubes"; 

//=============
// Parameter Section
parameter Real u_max(unit="m/s")=21"Maximum velocity";
parameter Real d(unit="cm")=2.54"Diameter of the tubes";

parameter Real k(unit="W/m.C")=0.0249"Thermal conductiviy at film temperature";
parameter Real v(unit="m^2/s")=14.2E-6"Kinematic viscocity at surface temperature";
parameter Real Pr=0.712"Prandtl Number";
parameter Real Pr_w=0.70"Prandtl number at wall temperature";

parameter Real C=0.27;
parameter Real n=0.63;

//=============
// Equation Section
equation
//Calculation of Reynolds Number
Red = (u_max*d*0.01)/v;

(h_bar*d*0.01)/k =  C*(Red^n) *((Pr/Pr_w)^0.25);

h_bar_correct = h_bar*0.92;

end Ex6_11;
//===================================================================
