// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.5  Page 291
// Title: Heat Transfer in a Rough Tube
//===================================================================
model Ex6_5
//=============
// Variable Section
Real T_bar(unit="C")"Average Temperature of water";
Real Tf(unit="C")"Mean Film temperature";
Real h(unit="W/m^2.C")"Heat Transfer coefficient ";
Real Red"Reynolds Number";
Real Nud"Nusselt Number";
Real L(unit="m")"Length of the tube";
Real q(unit="W")"Heat Transfer Rate";

//=============
// Parameter Section
parameter Real d(unit="cm")=2"Diameter of the tube";
parameter Real Tw(unit="C")=90"Constant Wall Temperature";
parameter Real Tw_i(unit="C")=40"Inlet temperature of water";
parameter Real Tw_o(unit="C")=60"Outlet temperature of water";
parameter Real u(unit="m/s")=3"Flow velocity";


//Properties evaluated at  Mean Film Temperature
parameter Real mu(unit="kg/m.s")=4E-4"Dynamic viscocity at mean film temperature";
parameter Real Pr=2.54"Prandtl Number";
parameter Real k(unit="W/m.C")=0.664"Thermal conductiviy at mean film temperature";
parameter Real rho(unit="kg/m^3")=978"Density of  water evaluated at the mean film temperature";
parameter Real Cp(unit="J/kg.K")=4174"Specific Heat Capacity";

parameter Real mu_b(unit="kg/m.s")=5.51E-4"Dynamic viscocity at bulk temperature";
parameter Real mu_w(unit="kg/m.s")=2.81E-4"Dynamic viscocity at wall temperature";
parameter Real f_by_8=0.002724"Friction Fctor obtained from Figure 6.4";
parameter Real n=0.11"Value obtained since Tw>Tb";

//=============
// Equation Section
equation
T_bar = (Tw_i +Tw_o)/2;
//Calculation of mean film temperature
Tf = (Tw+T_bar)/2;

//Calculation of Reynolds Number
Red = (rho*u*d*0.01)/(mu);

//Calculation of Nusselt Number using Petukhov relationship 
Nud=((f_by_8*Red*Pr)/((1.07+12.7*(f_by_8)^(0.5)*(Pr^(2/3)-1))))*((mu_b/mu_w)^(n)); 

h = Nud*(k/(d*0.01));
//Calculation of heat transfer rate
q = (989*3.14*(d*0.01)^2*u*Cp*(Tw_o-Tw_i))/4;
//Calculation of Length of the tube
q = h*3.14*d*0.01*L*(Tw-T_bar);

end Ex6_5;
//========================================================
