// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-6: Empirical and PracticalRelations forForced-Convection Heat Transfer
//Example: 6.8  Page 301
// Title: Heat Transfer from Electrically Heated Wire
//===================================================================
model Ex6_8

//=============
// Variable Section

Real Re_d"Reynolds Number";
Real Nu_d"Nusselt Number";

Real Nu_d_2"Nusselt number computed using Equation 6.21";
Real h_2"Heat Transfer coeffecient computed using new Nusselt Number";
Real q_L_2"Heat transfer rate computed using new heat transfer coefficient";

Real q_L(unit="W/m")"Heat Transfer per unit length";
Real T_f(unit="C")"Mean film temperature";
Real h(unit="W/m^2.C")"Heat Transfer Coeffiient"; 

//=============
// Parameter Section

parameter Real d(unit="m")=3.94E-5"Diameter of the wire";
parameter Real T_infinity(unit="C")=25"Temperature at which sirstream is flowing";
parameter Real u_infinity(unit="m/s")=50"Flow velocity";
parameter Real T_w(unit="C")=50"Temperature of wire surface";

//The below parameters are obtained from Table 6.2
parameter Real C=0.683;
parameter Real n=0.466 ;

//Properties evaluated at Film Temperature 310K
parameter Real v_f(unit="m^2/s")=16.7E-6"Kinematic viscocity at film temperature";
parameter Real Pr_f=0.706"Prandtl Number";
parameter Real k(unit="W/m.C")=0.02704"Thermal conductiviy at film temperature";

//=============
// Equation Section

equation
//Mean Film Temperature
T_f = (T_w+T_infinity)/2;

//Calculation of Reynolds Number
Re_d= (u_infinity*d)/(v_f);

//Calculation of Nusselt Number
Nu_d  = C*(Re_d)^n*(Pr_f)^(1/3);

//Calculation of heat transfer coefficient
h = Nu_d*(k/d);

//Heat transfer per unit length
q_L = 3.14*d*h*(T_w - T_infinity);
 
 //Calculation of q_L using Equation 6.21
 
 Nu_d_2 = 0.3 + ((0.62*(Re_d^0.5)*(Pr_f^(1/3)))/(1 +(0.4/Pr_f)^(2/3))^0.25) *(1 +(Re_d/282000)^0.5);
 
h_2 = Nu_d_2 *(k/d);
 
 q_L_2 = h*3.14*d*(T_w - T_infinity);
 
end Ex6_8;
//===================================================================
