// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.10  Page 353
// Title: Heat Transfer Across Water Layer
//===================================================================
model Ex7_10

//=============
//Variable Section

Real Tf(unit="F")"Film temperature";
Real Ra"Rayleigh Number";
Real ke(unit="W/m.C")"Effective thermal conductivity";
Real ke_k(unit="W/m.C")"Effective thermal conductivity";
Real q(unit="W")"Heat transfer rate";

//=============
//Parameter Section

parameter Real T1(unit="F")=100"Temperature of lower Plate";
parameter Real T2(unit="F")=80"Temperature of upper Plate";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";
parameter Real del_i(unit="cm")=1"Distance between the two plates";
parameter Real L(unit="cm")=50"Length of the horizontal square plates";

//Properties evaluated at film temperature

parameter Real k(unit="W/m.C")=0.623"Thermal conductivity of air at film temperature";
parameter Real K=2.48E10"Value used to compute Rayleigh number";

//Constants obtained from Table 7.3
parameter Real C= 0.13;
parameter Real n=0.3;
parameter Real m =0;


//=============
//Equation Section
equation
//Calculation of film temperature
Tf = (T1+T2)/2;

//Calculation of Rayleigh number
Ra = K *(del_i*0.01)^3*(T1-T2)*(5/9);
//Multiplication by 5/9 to convert Farenheit to Celcius

//Calculation of effective thermal conductivity
ke_k = C*(Ra^n);

ke = ke_k *k;

//Calculation of heat transfer
q = (ke *(L*0.01)^2*((T1-T2)*(5/9)))/(del_i*0.01);

end Ex7_10;
//================================================================================
