// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.12  Page 357
// Title: Heat Transfer Across Evacuated Space
//===================================================================
model Ex7_12

extends Modelica.Constants;

//=============
//Variable Section
Real lamda"Mean free path";
Real delta_T(unit="C")"Central temperature gradient";

//Conduction heat transfer
Real q_A(unit="W/m^2")"Heat transfer rate per unit area";
Real q_A_atm(unit="W/m^2")"Heat transfer rate per unit area at atmospheric pressure";

//Radiation Heat transfer
Real q_A_rad(unit="W/m^2")"Heat transfer rate per unit area";

//=============
//Parameter Section
parameter Real P(unit="atm")=10^(-6)"Pressure of air";
parameter Real T_1(unit="C")=100"Temperature of plate-I";
parameter Real T_2(unit="C")=30"Temperature of plate-II";
parameter Real e=0.06"Emmisivity of polished plates";


parameter Real L(unit="cm")=2.5"Distance between the two plates";

//Properties at mean air temperature of 65 C
parameter Real k(unit="W/m.C")=0.0291"Thermal conductivity at mean air temperature";
parameter Real gamma=1.4;
parameter Real Pr=0.7;
parameter Real alpha=0.9;

//=============
//Equation Section
equation
//Calculation of mean free path
lamda = (2.27*1E-5)*((((T_1+273)+(T_2+273))/2)/(1.01325*1E5*P));

 //Calculation of central temperature gradient
 delta_T = ((2-(alpha))/alpha)*((2*gamma)/(gamma+1))*(lamda/Pr)*((T_1 -T_2 - (2*delta_T))/(L*0.01));
 
//Conduction heat trasnfer
q_A = k*((T_1-T_2-(2*delta_T))/(L*0.01));

//Conduction heat transfer at atmospheric pressure
q_A_atm = k*((T_1 -T_2)/(L*0.01));

//Radiation heat transfer
q_A_rad =(sigma*((T_1+273)^4 -(T_2+273)^4))/(((2/e)-1));

end Ex7_12;
//================================================================================
