// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.2 Page 339
// Title: Heat Transfer from Isothermal Vertical Plate
//===================================================================
model Ex7_2
//=============
// Variable Section
Real Tf(unit="C")"Film temperature";
Real Nu"Nusselt Number";
Real h_bar(unit="W/m^2.C")"Heat transfer coefficient";
Real q(unit="W")"Heat transfer rate";
Real beta(unit="K^-1")"Coefficient of thermal expansion";
Real Ra"Rayleigh Number";
//=============
// Parameter Section
parameter Real H(unit="m")=4"Height of the vertical plate";
parameter Real W(unit="m")=10"Width of the vertical plate";
parameter Real Tw(unit="C")=60"Plate temperature";
parameter Real T_infinity(unit="C")=10"Surrounding atmosphere temperature";

//Properties evaluated at film temperature
parameter Real v(unit="m^2/s")=16.5E-6"Kinematic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.02685"Thermal conductivity of air at film temperature";
parameter Real Pr=0.7"Prandtl Number";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

//=============
// Equation  Section

equation
//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of film temperature
Tf  = (Tw+ T_infinity)/2;

//Calculation of Grashoff Number
Ra = ((g*beta*(Tw-T_infinity)*H^3)/(v*v))*Pr;

//Calculation of Nusselt Number
Nu^0.5 = 0.825 + (((0.387)*(Ra^(1/6)))/((1+(0.492/Pr)^(9/16))^(8/27)));

//Calculation of heat transfer coefficient
 Nu= (h_bar*H)/k;
 
 //Calculation of heat trasnfer rate
 q = h_bar *H*W*(Tw-T_infinity);
end Ex7_2;
//======================================================================================
