// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.7 Page 346
// Title: Calculation with Simplified Relations
//===================================================================
//Note: The below example is solved using parameters given in Example7_5
model Ex7_7
//=============
// Variable Section
Real h(unit="W/m^2.C")"Heat transfer coefficient";
Real q_L(unit="kW/m")"Heat transfer per unit length";

//=============
// Parameter Section
parameter Real Tw(unit="C")=250"Wire temperature";
parameter Real T_infinity(unit="C")=15"Surrounding atmosphere temperature";
parameter Real d(unit="m")=0.3048"Diameter of the pipe";

//=============
// Equation Section
equation
 
//Calculation of heat transfer coefficient
 h = 1.32 *(( Tw-T_infinity)/d)^0.25;
 
 //Calculation of rate of heat transfer per unit length
 q_L = h*3.14*d*(Tw-T_infinity)*1E-3;

end Ex7_7;
//=============================================================
