// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.8 Page 351
// Title: Heat Transfer Across Vertical Air Gap
//===================================================================
model Ex7_8

//=============
//Variable Section

Real Tf(unit="C")"Film temperature";
Real rho(unit="kg/m^3")"Density evaluated at film temperature";
Real beta(unit="K^-1")"Coefficient of thermal expansion";
Real Ra"Rayleigh Number";
Real ke_k(unit="W/m.C")"Effective thermal conductivity";
Real q_A(unit="W/m^2")"Radiant Heat Flux";
Real q_rad(unit="W")"Radiant heat transfer rate";
Real q(unit="W")"Heat transfer rate";

//=============
//Parameter Section

parameter Real T1(unit="C")=100"Temperature of Plate-1";
parameter Real P(unit="Pa")=101325"Pressure of air";
parameter Real T2(unit="C")=40"Temperature of Plate-2";
parameter Real R(unit="J/kg.K")=287"Gas constant";
parameter Real e=0.2"Emmisivity of both the surfaces";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";
parameter Real L(unit="m")=0.5"Length of the square plates";

//Properties evaluated at film temperature
parameter Real mu(unit="m^2/s")=2.043E-5"Dynamic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.0295"Thermal conductivity of air at film temperature";
parameter Real Pr=0.7"Prandtl Number";

parameter Real del_i(unit="m")=0.015"Distance between the two plates";

//Constants obtained from Table 7.3
parameter Real C= 0.197;
parameter Real n=0.25;
parameter Real m =-0.111;

//=============
//Equation Section
equation
//Calculation of density at film temperature
rho = P/(R*(Tf+273));

//Calculation of film temperature
Tf  = (T1+ T2)/2;

//Calculation of Coefficient of thermal expansion
beta = 1/(Tf+273);

//Calculation of Rayleigh Equation
Ra = (g*beta*rho*rho * (T1-T2)*(del_i)^3*Pr)/(mu*mu);

//Calculation of effective thermal conductivity
ke_k = C*(Ra^n)*(L/del_i)^m;

//Calculation of heat transfer
q = (ke_k *k*(L)^2*(T1-T2))/(del_i);

//Calculation of radiant heat flux
q_A = ((5.669*1E-8)*((T1+273)^4 - (T2+273)^4))/(1/e + 1/e -1);

//Calculation of radiation heat transfer rate
q_rad = q_A * (L)^2;

end Ex7_8;
//====================================================================================
