// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-7: Natural Convection Systems
//Example: 7.9 Page 352
// Title: Heat Transfer Across Horizontal Air Gap
//===================================================================
//Note : The properties in the below Example are same as that of Example7_8
model Ex7_9

//=============
//Variable Section

Real Ra"Rayleigh Number";
Real ke_k(unit="W/m.C")"Effective thermal conductivity";
Real q(unit="W")"Heat transfer rate";

//=============
//Parameter Section
parameter Real T1(unit="C")=100"Temperature of Plate-1";
parameter Real T2(unit="C")=40"Temperature of Plate-2";
parameter Real g(unit="m/s^2")=9.81"Gravitational constant";

//Properties evaluated at film temperature
parameter Real mu(unit="kg/m.s")=2.043E-5"Dynamic viscocity of air at film temperature";
parameter Real k(unit="W/m.C")=0.0295"Thermal conductivity of air at film temperature";
parameter Real Pr=0.7"Prandtl Number";
parameter Real rho(unit="kg/m^3")=1.029"Density evaluated at film temperature";
parameter Real beta(unit="K^-1")=2.915*1E-3"Coefficient of thermal expansion obtained from Example 7_8";

//Constants obtained from Table 7.3
parameter Real C= 0.059;
parameter Real n=0.4;
parameter Real m =0;

parameter Real del_i(unit="m")=0.01"Distance between the two plates";
parameter Real L(unit="cm")=20"Length of the square plates";

//=============
//Equation Section
equation
//Calculation of Rayleigh Equation
Ra = (g*beta*rho*rho * (T1-T2)*(del_i)^3*Pr)/(mu*mu);

//Calculation of effective thermal conductivity
ke_k = C*(Ra^n)*(L/del_i)^m;

//Calculation of heat transfer
q = (ke_k *k*(L*0.01)^2*(T1-T2))/(del_i);

end Ex7_9;
//==========================================================================
