// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.10 Page 418
//Title: Heat-Transfer Reduction with Parallel-Plate Shield
//===================================================================
//Note :Figure 8.34 is reffered for the below problem
model Ex8_10
//=============
// Variable Section
Real R1,R2,R3;
Real R"Total resistance with sheild";

Real Reduction(unit="%")"Percentage reduction in heat transfer rate";
//=============
// Parameter Section
parameter Real E1=0.3"Emmisivity of first plane";
parameter Real E2=0.8"Emmisivity of second plane";
parameter Real E3=0.04"Emmisivity of sheild";

parameter Real sigma(unit="W/m^2.K^4") =5.67E-8"Stefan Boltman constant";

//=============
// Equation Section
equation

R1 = (1-E1)/E1 ;
R2 = (1-E2)/E2 ;
R3 = (1-E3)/E3 ;

R = R1+R2+R3;

Reduction =( (0.279-0.01902)/0.279)*100;

//Note: Since the temperatures are not mentioned in the problem statement the heat transfer rates withand without shield are compared and the percentage reduction is computed

end Ex8_10;

//========================================================================
