// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-8: Radiation Heat Transfer
//Example: 8.4 Page 402
//Title: Shape-Factor Algebra for Truncated Cone
//===================================================================
model Ex8_4
//=============
// Variable Section 
Real A1;
Real A2;
Real F_21;
Real F_13;
Real A3;
//Constants used to obtain F_12 from Figure 8.16
Real X;
Real Y;

Real F_23"Shape factor between top and side surface";

Real F_31;
Real F_32;
Real F_33"Shape factor between side and itself";


//=============
// Parameter Section 
parameter Real d1(unit="cm")=10"Diameter of top of the cone";
parameter Real d2(unit="cm")=20"Diameter of bottom of the cone";
parameter Real L(unit="cm")=10"Height of the cone";

parameter Real F_22=0;
parameter Real F_12=0.12;

//=============
// Equation Section 
equation
A1 =( 3.14*(d1)^2)/4;

A2 =( 3.14*(d2)^2)/4;

//Top portion is considered as Surface 2 , Bottom portion as Surface 1 and side as Surface 2 
X = L/(d2/2);

Y = (d1/2)/L;

//Reciprocity theorm
F_21 = (A2/A1)*(F_12);

F_23 = 1-F_21;

F_13 = 1-F_12;

//Surface area of the side
A3 = 3.14*(d1/2 +d2/2)*((d1/2 - d2/2)^(2) +(L^2))^0.5;

//Calculation of Shape Factors
F_31 = A2*(F_13/A3);

F_32 = A1*(F_23/A3); 

F_33 = 1-F_32-F_31 ;

end Ex8_4;
//========================================================================
