// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-9:  Condensation and Boiling Heat Transfer
//Example: 9.3 Page 503
//Title: Boiling on Brass Plate
//===================================================================
model Ex9_3

//=============
// Variable Section
Real q_A_waterbrass(unit="Btu/h.ft^2")"Heat transfer per unit area of plate";
Real delta_T(unit="F")"Temperature Difference";


//=============
// Parameter Section
parameter Real q_A_waterplatinum(unit="Btu/h.ft^2")=3E5"Heat flux for water platinum combination obtained from Fig:9:8";
parameter Real T_w(unit="F")=242"Plate temperature";
parameter Real T_sat(unit="F")=212" Saturation temperature";
parameter Real C_sf_wateraluminium= 0.013"Fluid heating surface combination for water platinum obtained from Table 9.2";
parameter Real C_sf_waterbrass= 0.006"Fluid heating surface combination for water brass obtained from Table 9.2";

//=============
//  Equation Section
equation
delta_T = T_w - T_sat;

//Calculation of Heat transfer per unit area of plate
q_A_waterbrass =  (q_A_waterplatinum)*(C_sf_wateraluminium/C_sf_waterbrass)^3;

end Ex9_3;

//===================================================================
